"""Simple program to demo how to use meshtastic library.
   To run: python examples/info.py
"""

import meshtastic
import meshtastic.serial_interface

from enum import Enum

class RegionCode(Enum):
    UNSET = 0
    """
    Region is not set
    """
    US = 1
    """
    United States
    """
    EU_433 = 2
    """
    European Union 433mhz
    """
    EU_868 = 3
    """
    European Union 868mhz
    """
    CN = 4
    """
    China
    """
    JP = 5
    """
    Japan
    """
    ANZ = 6
    """
    Australia / New Zealand
    """
    KR = 7
    """
    Korea
    """
    TW = 8
    """
    Taiwan
    """
    RU = 9
    """
    Russia
    """
    IN = 10
    """
    India
    """
    NZ_865 = 11
    """
    New Zealand 865mhz
    """
    TH = 12
    """
    Thailand
    """
    LORA_24 = 13
    """
    WLAN Band
    """
    UA_433 = 14
    """
    Ukraine 433mhz
    """
    UA_868 = 15
    """
    Ukraine 868mhz
    """
    MY_433 = 16
    """
    Malaysia 433mhz
    """
    MY_919 = 17
    """
    Malaysia 919mhz
    """
    SG_923 = 18
    """
    Singapore 923mhz
    """

    def is_region_code(value):
        try:
            RegionCode[value]
        except:
            return False
        return True

interface = meshtastic.serial_interface.SerialInterface()
node = interface.getNode('^local')

#print(node.localConfig.lora)
# Region UNSET is 0

region_int = node.localConfig.lora.region

print(node.localConfig)
print(node.localConfig.lora)

print("The enum member associated with value " + str(region_int) + " is : ", RegionCode(region_int).name)
print("The enum member associated with name US is : ", RegionCode['US'].value)

if region_int == 0:
    new_region = "US"
    if RegionCode.is_region_code(new_region):
        node.localConfig.lora.region = RegionCode[new_region].value
        node.writeConfig("lora")
        print("Changing region to: " + new_region)
    else:
        print(new_region + " is not a valid region")

interface.close()
